package hps.learn.eliza;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.support.v4.app.NavUtils;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnKeyListener;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;

public class MainActivity extends Activity {
    static String scriptPathname = "script";
    static final boolean local = true; // script file must be local
	final String STATE_OUTPUT_TEXT="outputText";
    ElizaMain eliza;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		// TextView output=(TextView)findViewById(R.id.output);
		// output.append("Test");
        String script = scriptPathname;
        //InputStream file = getResources().openRawResource(R.raw.script);
    	Resources rsrcs=getResources();
        eliza = new ElizaMain();
        int res = eliza.readScript(rsrcs, local, script);
        String greeting;
        if (res != 0)
        	greeting="Oops, Doctor not here: The script file (script) is missing!";
        else
            greeting=getResources().getString(R.string.greeting);
        final EditText input=(EditText)findViewById(R.id.input);
        input.setOnKeyListener(new OnKeyListener() {
        	public boolean onKey(View v,int keycode,KeyEvent event) {
                if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
                        (keycode == KeyEvent.KEYCODE_ENTER)) {
                      // Perform action on key press:
                    sendProblem(input);
                    return true;
                }
                return false;
            }
        });
		final TextView output=(TextView)findViewById(R.id.output);
		if (savedInstanceState != null) {
			output.setText(savedInstanceState.getString(STATE_OUTPUT_TEXT));
    		output.append("");
    		//int endpos=output.length(); // This crashes when ...
    		//output.bringPointIntoView(endpos); // rotating the screen
        	scrollToBottom();
		}
		else {
        	//output.setMovementMethod(new ScrollingMovementMethod());
        	output.setText(greeting);
		}
	}

	@Override
	public void onSaveInstanceState(Bundle savedInstantState) {
		final TextView output=(TextView)findViewById(R.id.output);
		final String mOutputText=output.getText().toString();
		savedInstantState.putString(STATE_OUTPUT_TEXT,mOutputText);
		super.onSaveInstanceState(savedInstantState);
	}

	private void scrollToBottom() {
		final TextView output=(TextView)findViewById(R.id.output);
		final ScrollView mScrollView = (ScrollView)findViewById(R.id.SCROLLER_ID);
	    mScrollView.post(new Runnable() { 
	        public void run() { 
	            mScrollView.smoothScrollTo(0, output.getBottom());
	        } 
	    });
	}

	@Override
	public boolean onCreateOptionsMenu(Menu menu) {
		// Inflate the menu; this adds items to the action bar if it is present.
		getMenuInflater().inflate(R.menu.main, menu);
		return true;
	}
	
	public boolean onOptionsItemSelected(MenuItem item) {
	    //respond to menu item selection
		switch (item.getItemId()) {
	    case R.id.about:
	    	startActivity(new Intent(this, About.class));
	    	return true;
        case android.R.id.home:
            // This ID represents the Home or Up button. In the case of this
            // activity, the Up button is shown. Use NavUtils to allow users
            // to navigate up one level in the application structure. For
            // more details, see the Navigation pattern on Android Design:
            //
            // http://developer.android.com/design/patterns/navigation.html#up-vs-back
            //
            NavUtils.navigateUpFromSameTask(this);
            return true;
	    default:
	    	return super.onOptionsItemSelected(item);
	}
	}




	// public boolean onKey(View v,int keycode,KeyEvent event) {
	//	// if event is a key down event and the key code is Enter:
    //    if ((event.getAction() == KeyEvent.ACTION_DOWN) &&
    //            (keycode == KeyEvent.KEYCODE_ENTER)) {
    //        // Perform action on key press
    //    	sendProblem(v);
    //        return true;
    //    }
    //    return false;
    // }

	public void sendProblem(View view) {
		EditText input=(EditText)findViewById(R.id.input);
		TextView output=(TextView)findViewById(R.id.output);
		String problem=input.getText().toString();
		output.append(problem+"\nDr.>");
		String reply=eliza.processInput(input.getText().toString());
		output.append(reply+"\nYou>");
		int endpos=output.length();
		output.bringPointIntoView(endpos);
		scrollToBottom();
		input.setText("");
		//input.setHint(R.string.inputHint);
	}

}
