﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.IO;

namespace charConvert {

    class CharSubstitute {
        public string nl=Environment.NewLine;
        int nlslen;
        int[] nls;

        // public string nlWrt;

        public CharSubstitute() {
            nl = Environment.NewLine;
            // nlWrt = Environment.NewLine;
        }

        //private int substitutions = 0;
        //public int Substitutions {
        //    get { return substitutions; }
        //    set { substitutions = value; }
        //}
        //public override string ToString() {
        //    return substitutions.ToString();
        //}

        // returns number of substitutions if not canceled or number
        // of substitutions+1 as negative value if canceled. Can be canceled
        // when running as a separate thread, if another thread sets startBtn
        // to Model.StartBtnState.Start (no typo ...Start is correct). If an
        // error occures when writing, the negated number of total chars + 1
        // written is returned
        public int processFile(string file,bool htmlMode,
                Dictionary<string,string> convertDic,List<string> errorList,
                        NewLineConvert newLineConversion,
                                ref Model.StartBtnState startBtn) {
            int substitutions = 0;
            // Dummy test code, for testing aborting (canceling) processing:
            //int i; for (i=0; i < 10; i++) {
            //    if (startBtn == Model.StartBtnState.Start) { // if abort request
            //        return -i-1; // return substitutions+1 as negative value
            //    }
            //    System.Threading.Thread.Sleep(100);
            //}
            //return i;

            FileInfo fi;
            try { fi = new FileInfo(file); }
            catch (PathTooLongException) {
                if (errorList != null)
                    errorList.Add(file+nl+Properties.Resources.errPathToLong);
                return -1;
            }
            catch (Exception e) {
                if (e is System.Security.SecurityException ||
                        e is UnauthorizedAccessException)
                    if (errorList != null)
                        errorList.Add(file+nl+Properties.Resources.errNoPermission);
                return -1;
            }
            // All other errors (like file does not exist, wrong filename, ...)
            // are not logged but just ignored, cause these files don't exist
            if (!fi.Exists)
                return 0; // Not existing files are not logged

            // Currently only files wich fits into a StringBuilder are
            // supported. As we process files which were created by humans,
            // this should be enough:
            long flen =fi.Length;
            if (flen > (Int32.MaxValue-100000000)) {
                if (errorList != null)
                    errorList.Add(file+nl+Properties.Resources.errFileTooBig);
                return -1;
            }

            FileStream fs=null;
            // For testing purposes you can uncomment the following statement:
            // System.Threading.Thread.Sleep(100);
            try {
                fs = new FileStream(file,FileMode.Open,FileAccess.ReadWrite);
            }
            catch (UnauthorizedAccessException) {
                if (errorList != null)
                    errorList.Add(file+nl+Properties.Resources.errReadOnly);
                return -1;
            }
            catch (Exception) {
                if (errorList != null)
                    errorList.Add(file+nl+Properties.Resources.errFileNotOpened);
                return -1; // as we have checked for possible errors before, it
                          // is unknown, why the file cannot be opened
            }
            using (fs) {
                StreamReader sr;
                //try { sr = fi.OpenText(); } // This doesn't work with
                // Non-ASCII chars (e. g. the German Umlaut a (ae in
                // HTML &auml;). "German a Umlaut on a German Windows
                // is: ä (Note the char before may look "strange" on
                // none German Windows Systems. You must use:
                try { sr = new StreamReader(fs,System.Text.Encoding.Default); }
                //                             ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
                //TODO: The above hard coded encoding works only with ASCII encoded
                // files, If the file is encoded as e. g. UTF-8 most German Umlauts
                // are handled correctly, but not the Paragraph char (in UTF it is
                // called the Section Sign, in HTML: &sect;) and other chars. So
                // make the encoding adjustable in a future version(!).
                catch {
                    if (errorList != null)
                        errorList.Add(file+nl+Properties.Resources.errFileNotOpened);
                    return -1; // as we have checked for possible errors before, it
                               // is unknown, why the file cannot be opened
                }
                StringBuilder sb = new StringBuilder((int)(flen+flen*0.1) >
                            Int32.MaxValue ? Int32.MaxValue : (int)(flen+flen*0.1));

                // Start processing:
                string nlw = null;
                if (newLineConversion.Read != null && newLineConversion.Read != "") {
                    nlslen = newLineConversion.Read.Length;
                    if (nlslen > 0 && newLineConversion.Write != null) {
                        nls = new int[nlslen];
                        nlw = newLineConversion.Read == newLineConversion.Write ?
                                null : newLineConversion.Write;
                        for (int j = 0;j < nlslen;j++)
                            nls[j]=newLineConversion.Read[j];
                    }
                }
                string subst = null;
                int ci = sr.Read();
                substitutions=0;
                while (ci >= 0) {
                    // Test abort condition (user canceled processing):
                    if (startBtn == Model.StartBtnState.Start) {
                        sr.Close(); // closes also the FileStream fs
                        return -1;
                    }
                    int rorre = 0;
                    if (nlw != null && ci == nls[0]) {
                        rorre = handleNewLine(sr,sb,ref ci,nlw);
                        continue;
                    }
                    if (ci == '<') {
                        if (htmlMode) {
                            // sb.Append(ci);
                            rorre = handleTag(sr,sb,ref ci,nlw);
                            continue;
                        }
                    }
                    // Process ci and add result (the char or the
                    // substitution string) to StringBuilder sb:
                    if (convertDic.TryGetValue(((char)ci).ToString(),out subst)) {
                        sb.Append(subst);
                        substitutions++;
                    }
                    else
                        sb.Append((char)ci);
                    ci = sr.Read();
                }


                // Test abort condition (user canceled processing):
                if (startBtn == Model.StartBtnState.Start) {
                    sr.Close(); // closes also the FileStream fs
                    return -1;
                    // We don't cancel processing when writing, cause this would
                    // result in partly processed files
                }
                try {
                    fs.SetLength(0); // Truncate the file to 0 (empty the file)
                }
                catch (IOException) {
                    if (errorList != null)
                        errorList.Add(file+nl+Properties.Resources.errIOException);
                    return -1;
                }
                catch (Exception) {
                    if (errorList != null)
                        errorList.Add(file+nl+Properties.Resources.errWriteNotSupported);
                    return -1;
                }

                StreamWriter sw = null;
                try { sw = new StreamWriter(fs,System.Text.Encoding.Default); }
                catch (Exception) {
                    if (errorList != null)
                        errorList.Add(file+nl+Properties.Resources.errWriteNotSupported);
                    return -1;
                }
                int sblen = sb.Length;
                int i=0;
                try {
                    for (i=0;i < sblen;i++) {
                        sw.Write(sb[i]);
                    }
                }
                catch (Exception) {
                    if (errorList != null)
                        errorList.Add(file+nl+Properties.Resources.errIOException);
                    return -i+1; // return total number of characters written
                }
                sw.Flush();
            } // using (fs)

            return substitutions;
        }

        // handleTag() processes an html tag and returns char after
        //             the closing '>'. Inside tags (even if they
        //             are comments) no substitutions are made(!):
        private int handleTag(StreamReader sr,StringBuilder sb,ref int ci,
                        string nlw) {
            int rorre;
            while (ci >= 0) {
                if (nlw != null && ci == nls[0]) {
                    rorre = handleNewLine(sr,sb,ref ci,nlw);
                    continue;
                }
                sb.Append((char)ci);
                ci = sr.Read();
                if (ci == '>') {
                    sb.Append((char)ci);
                    ci = sr.Read();
                    return ci;
                }
                if (ci == '!') {
                    sb.Append((char)ci);
                    ci = sr.Read();
                    if (ci == '-') {
                        sb.Append((char)ci);
                        ci = sr.Read();
                        if (ci == '-') {
                            sb.Append((char)ci);
                            ci = sr.Read();
                            findEndComment(sr,sb,ref ci,nlw);
                            return ci;
                        }
                    }
                }
            }
            return ci;
        }

        // findEndComment() finds end of comment (-->), ci holds char after comment:
        private void findEndComment(StreamReader sr,StringBuilder sb,
                        ref int ci,string nlw) {
            int rorre;
            while (ci >= 0) {
                if (nlw != null && ci == nls[0]) {
                    rorre = handleNewLine(sr,sb,ref ci,nlw);
                    continue;
                }
                if (ci == '-') {
                    sb.Append((char)ci);
                    ci = sr.Read();
                    if (ci == '-') {
                        sb.Append((char)ci);
                        ci = sr.Read();
                        if (ci == '>') {
                            sb.Append((char)ci);
                            ci = sr.Read();
                            return;
                        }
                    }
                }
                else {
                    sb.Append((char)ci);
                    ci = sr.Read();
                }
            }
            return;
        }

        private int handleNewLine(StreamReader sr,StringBuilder sb,ref int ci,
                string nlw) {
            string toWrite=((char)ci).ToString();
            int i; for (i = 1; i < nlslen; i++) {
                ci=sr.Read();
                if (ci == nls[i])
                    toWrite += ((char)ci).ToString();
                else
                    break;
            }
            if (i == nlslen) {
                sb.Append(nlw);
                ci=sr.Read();
            }
            else
                sb.Append(toWrite);
            return ci;
        }
    } // class CharSubstitute
}
