﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.ObjectModel;


namespace charConvert {
    class Model {
        private NewLineConvert nlConvert = null;
        // private int nlConvIndex=0;
        private string dir;
        private bool htmlMode;
        //private List<string> files;
        private ObservableCollection<string> files;
        private ObservableCollection<Converter> convertColl;
        private string description; // File type description for file dialog
        private List<string> fileTypes;
        public enum StartBtnState { Start, Cancel };
        internal StartBtnState startBtn;

        public NewLineConvert NewLineConversion {
            get { return nlConvert; }
            set { nlConvert = value == null ? new NewLineConvert() : value; }
        }
        //public int newLineConvIndex {
        //    get { return nlConvIndex; }
        //    set { nlConvIndex = value; }
        //}

        public string StartDirectory {
            get { return dir; }
            set { dir = value == null ? "" : value; }
        }

        public bool HtmlMode {
            get { return htmlMode; }
            set { htmlMode = value; }
        }

        public ObservableCollection<string> SelectedFiles {
            get { return files; }
            set { files = value == null ? new ObservableCollection<string>() : value; }
        }

        public string Description {
            get { return description; }
            set { description = value; }
        }

        public List<string> FileTypes {
            get { return fileTypes; }
            set { fileTypes = value; }
        }

        public ObservableCollection<Converter> ConvertColl {
            get { return convertColl; }
            set { convertColl = value; }
        }

        // Constructor(s):
        public Model() {
            dir = "";
            startBtn = StartBtnState.Start;
            convertColl = null;
            nlConvert = nlConvert == null ? new NewLineConvert() : nlConvert;
        }
        public Model(string startDirectory,
                    NewLineConvert NewLineConversion=null) : this() {
            this.StartDirectory = startDirectory;
            nlConvert = NewLineConversion;
        }
        public Model(Model model) {
            if (model == null)
                throw new NullReferenceException("Argument 1 (model) must not be null");
            dir = model.dir;
            nlConvert = model.nlConvert;
            htmlMode = model.htmlMode;
            files = new ObservableCollection<string>();
            foreach (var file in model.files)
                files.Add(file);
            convertColl = new ObservableCollection<Converter>();
            foreach (var converter in convertColl)
                convertColl.Add(converter);
            description = model.description;
            fileTypes = new List<string>();
            foreach (var ftyp in fileTypes)
                fileTypes.Add(ftyp);
            startBtn = model.startBtn;
        }
    } // class Model

}
