﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Runtime.InteropServices;

// .ini-file access see:
// https://code.msdn.microsoft.com/Reading-and-Writing-Values-85084b6a

namespace charConvert {
    class IniFileAccess {
        public static int capacity = 1024;

        public static string ReadIniValue(string section,string key,
            string filePath,string defaultValue = "") {
            var value = new StringBuilder(capacity);
            GetPrivateProfileString(section,key,defaultValue,value,
                value.Capacity,filePath);
            return value.ToString();
        }

        public static string[] ReadIniKeyValuePairs(string section,string filePath) {
            while (true) {
                IntPtr returnedString = Marshal.AllocCoTaskMem(capacity * sizeof(char));
                int size = GetPrivateProfileSection(section,returnedString,capacity,filePath);

                if (size == 0) {
                    Marshal.FreeCoTaskMem(returnedString);
                    return null;
                }

                if (size < capacity - 2) {
                    string result = Marshal.PtrToStringAuto(returnedString,size - 1);
                    Marshal.FreeCoTaskMem(returnedString);
                    string[] keyValuePairs = result.Split('\0');
                    return keyValuePairs;
                }

                Marshal.FreeCoTaskMem(returnedString);
                capacity = capacity * 2;
            }
        }

        [DllImport("kernel32",CharSet = CharSet.Unicode)]
        private static extern int GetPrivateProfileString(string section,string key,
            string defaultValue,StringBuilder value,int size,string filePath);

        [DllImport("kernel32.dll",CharSet = CharSet.Auto)]
        private static extern int GetPrivateProfileSection(string section,IntPtr keyValue,
            int size,string filePath);
    }
}
