﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

using System.Collections.ObjectModel;
using System.Globalization;
using System.IO;
using System.Threading;

namespace charConvert {
    /// <summary>
    /// Interaktionslogik für MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window {

        //readonly string version = "0.99 beta";
        //private List<NewLineConvert> newLineConversions;
        //public List<NewLineConvert> NewLineConversions {
        //    get { return newLineConversions; }
        //}
        ViewModel vm = null;
        // ObservableCollection<Converter> convertColl;
        public MainWindow() {
            string culture = null;
            culture = IniFileAccess.ReadIniValue("Localization",
                "culture",".\\charConvert.ini");
            
            if (culture != null && !culture.Equals("")) {
                // MessageBox.Show(culture);
                // Gewünschte Kultur (für z. B. Währung, Datum) einstellen:
                System.Threading.Thread.CurrentThread.CurrentCulture=
                    new CultureInfo(culture); //using System.Globalization

                // Gewünschte Kultur für die Sprache (User Interface) einstellen:
                System.Threading.Thread.CurrentThread.CurrentUICulture=
                    System.Threading.Thread.CurrentThread.CurrentCulture;

            }
            Closing += onWindowClosing;
            InitializeComponent();
            // GetCommandLineArgs() is in ViewModel:
            // string[] cla = Environment.GetCommandLineArgs();
            vm=new ViewModel(new Model());
            cbxLineConversions.ItemsSource=vm.NlConvert;
            vm.init();
            cbxLineConversions.SelectedIndex=vm.NlConvIndex;
            init();
        }

        private int init() {
            DPconvert.DataContext=vm.mdl.ConvertColl;
            tbxDirectory.Text = vm.mdl.StartDirectory;
            chkHtmlMode.IsChecked = vm.mdl.HtmlMode;
            return 0;
        }

        private void btnSelectFiles_Click(object sender,RoutedEventArgs e) {
            vm.mdl.StartDirectory = tbxDirectory.Text;
            lbxFiles.ItemsSource = vm.selectFiles(tbxDirectory.Text);
            tbxDirectory.Text = vm.mdl.StartDirectory;
            lblFile.Content="";
        }

        private void btnRemove_Click(object sender,RoutedEventArgs e) {
            if (vm == null)
                return;
            if (vm.mdl.SelectedFiles == null)
                return;
            vm.removeFile(lbxFiles.SelectedIndex);
            //var sel = lbxFiles.SelectedIndex;
            //if (sel != -1)
            //    ((IList<string>)lbxFiles.ItemsSource).RemoveAt(sel);
        }

        private void btnStart_Click(object sender,RoutedEventArgs e) {
            //Func<Action<string>,Action<string>,int> handleStartBtn =
            //    vm.handleStartBtn;
            vm.mdl.NewLineConversion =
                        (NewLineConvert)cbxLineConversions.SelectedItem;
            Func<Action<string>,Action<string>,List<string>>
                        handleStartBtn = vm.handleStartBtn;
            IAsyncResult rslt = handleStartBtn.BeginInvoke(btnStart_Content,
                lblFile_Content,btnStart_Click_callback,handleStartBtn);
        }
        internal void btnStart_Content(string content) { // To set content from a thread
            // NOTE: .CheckAccess is not offered by IntelliSense in Visual Studio:
            if (btnStart.Dispatcher.CheckAccess())
                btnStart.Content = content;
            else
                btnStart.Dispatcher.BeginInvoke(((Action)(() =>
                    btnStart.Content=content)));
        }
        internal void lblFile_Content(string content) { // To set content from a thread
            // NOTE: .CheckAccess is not offered by IntelliSense in Visual Studio:
            if (lblFile.Dispatcher.CheckAccess())
                lblFile.Content = content;
            else
                lblFile.Dispatcher.BeginInvoke(((Action)(() =>
                    lblFile.Content = content)));
        }
        internal void showErrLog(List<string> errList) {
            WindowErrorLog wErrLog = new WindowErrorLog();
            wErrLog.Owner=this;
            wErrLog.lbxErrorLog.ItemsSource=errList;
            wErrLog.ShowDialog();
        }

        private void btnStart_Click_callback(IAsyncResult rslt) {
            Object obj = rslt.AsyncState;
            var handleStartBtn = (Func<Action<string>,Action<string>,List<string>>)obj;
            var rslt_handleStartBtn = handleStartBtn.EndInvoke(rslt);
            if (rslt_handleStartBtn == null)
                return;
            //MessageBox.Show(rslt_handleStartBtn[0]);
            // MessageBox.Show() above works, as it opens a new window with a
            // static method. But this doesn't work, cause it runs in another
            // thread than the UI thread and is not a static method:
            //WindowErrorLog wErrLog = new charConvert.WindowErrorLog();
            //wErrLog.Owner=this;
            //wErrLog.lbxErrorLog.ItemsSource=rslt_handleStartBtn;
            //wErrLog.ShowDialog();

            // So we must use this (together with method showErrLog):
            var sel = (Action<List<string>>)showErrLog;
            App.Current.Dispatcher.Invoke(sel,rslt_handleStartBtn);
        }

        internal void onWindowClosing(object sender,
            System.ComponentModel.CancelEventArgs e) {
            if (!vm.isProcessing())
                e.Cancel = false;
            else {
                MessageBox.Show(Properties.Resources.msgProcessingFiles,
                    Properties.Resources.msgCaptionProcessingFiles);
                e.Cancel = true;
            }
        }

        private void btnQuit_Click(object sender,RoutedEventArgs e) {
            this.Close();
        }

        private void btnAbout_Click(object sender,RoutedEventArgs e) {
            //MessageBox.Show(Properties.Resources.btnAboutMessageS);
            var wAbout = new WindowAbout();
            wAbout.ShowDialog();
        }
    } // class MainWindow
} // namespace charConvert
