﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Windows.Forms;
using System.Collections.ObjectModel;
using System.IO;
using charConvert.Properties;

namespace charConvert {
    class ViewModel {
        public Model mdl;
        private string iniFile = null;
        private ObservableCollection<NewLineConvert> nlConvert;
        public string IniFilePath {
            get { return iniFile; }
            set { iniFile = value; }
        }
        public ObservableCollection<NewLineConvert> NlConvert {
            get { return nlConvert; }
            //private set { nlConvert = value; }
        }
        private int nlConvIndex;
        public int NlConvIndex {
            get { return nlConvIndex; }
            set {
                if (nlConvert == null || !(nlConvIndex < nlConvert.Count) ||
                            nlConvIndex < 0)
                    nlConvIndex = 0;
                else
                    nlConvIndex = value;
            }
        }

        // Constructor(s):
        public ViewModel(Model model) {
            if (model == null)
                mdl = new Model();
            else
                mdl = model;
            if (nlConvert == null) {
                nlConvert =new ObservableCollection<NewLineConvert>();
            }
            else
                nlConvert.Clear();
            //nlConvert.Add(new NewLineConvert("CR,LF -> CR,LF","\r\n","\r\n"));
            nlConvert.Add(new charConvert.NewLineConvert(
                    Resources.noNewLineConversionS,null,null));
            nlConvert.Add(new NewLineConvert("CR,LF -> LF","\r\n","\n"));
            nlConvert.Add(new NewLineConvert("CR,LF -> CR","\r\n","\r"));
            nlConvert.Add(new NewLineConvert("LF -> CR,LF","\n","\r\n"));
            //nlConvert.Add(new NewLineConvert("LF -> LF","\n","\n"));
            nlConvert.Add(new NewLineConvert("LF -> CR","\n","\r"));
            nlConvert.Add(new NewLineConvert("CR -> CR,LF","\r","\r\n"));
            nlConvert.Add(new NewLineConvert("CR -> LF","\r","\n"));
            //nlConvert.Add(new NewLineConvert("CR -> CR","\r","\r"));
        }

        internal ObservableCollection<string> selectFiles(string StartDirectory) {
            var ofd = new OpenFileDialog();
            ofd.Multiselect=true;
            ofd.InitialDirectory=mdl.StartDirectory;
            // Im Filter unten KEINE Leerzeichen setzen (!):
            //ofd.Filter="HTML Files|*.htm;*.html;*.php;*.hti|All files|*.*";
            string types = mdl.Description+"|";
            foreach (var type in mdl.FileTypes)
                types += type+";";
            string delme = types.Substring(0,types.Length-1);
            ofd.Filter = types.Substring(0,types.Length-1) + "|"+"All files|*.*";
            if (ofd.ShowDialog() == System.Windows.Forms.DialogResult.OK) {
                if (mdl.SelectedFiles == null)
                    mdl.SelectedFiles = new ObservableCollection<string>();
                else
                    mdl.SelectedFiles.Clear();
                var files = ofd.FileNames;
                var fi = new FileInfo(files[0]);
                mdl.StartDirectory = fi.DirectoryName;
                // mdl.selectedFiles.AddRange(files); // This gives NullReferenceException
                FileInfo finfo = null;
                foreach (var file in files) {
                    finfo = new FileInfo(file);
                    if (!Directory.Exists(file) && File.Exists(file))
                        mdl.SelectedFiles.Add(file);
                }
            }
            return mdl.SelectedFiles;
        }
        internal void removeFile(int index) {
            if (index != -1)
                mdl.SelectedFiles.RemoveAt(index);
        }

        internal int init(string iniFilePath=null) {
            string[] clArgs = Environment.GetCommandLineArgs();

            // N O T E :   The following is totally Windows specific ! ! !
            // If you want to port this program to other operating systems
            // (e. g. UNIX), it's nearly sure, that you have to port this
            // code:
            for ( int clNo=1; clNo < clArgs.Length; clNo++) {
                if (clArgs[clNo] == "-ini") {
                    iniFilePath = clArgs[clNo+1];
                    if (iniFilePath.Substring(0) != "\\" ||
                            iniFilePath.Substring(0,2) != ".\\") {
                        if (char.IsLetter(iniFilePath[0]) &&
                                    iniFilePath.Substring(1,2) != ":\\")
                            iniFilePath = ".\\" + iniFilePath;
                    }
                }
            }
            if (mdl.ConvertColl == null)
                mdl.ConvertColl = new ObservableCollection<Converter>();
            mdl.ConvertColl.Clear();

            iniFile = iniFilePath == null ? ".\\charConvert.ini" : iniFilePath;

            // Preset New Line conversion:
            string ndx = IniFileAccess.ReadIniValue("NewLine","conversion",iniFile,"0");
            if (!int.TryParse(ndx,out nlConvIndex))
                nlConvIndex = 0;
            NlConvIndex = nlConvIndex;

            // Preset Substitutions:
            string[] temp = IniFileAccess.ReadIniKeyValuePairs(
                "Substitutions",iniFile);
            if (temp != null) {
                foreach (string subst in temp) {
                    //    MessageBox.Show(temp);
                    // and add it to convertColl
                    string c = subst.Substring(0,1);
                    string s = subst.Substring(1).Trim();
                    // Old:
                    // if (s[0] != '=') // second non whitspace char must be "="
                    // Improved in version 1.0.2 to support whitspace as first char:
                    if (s.Substring(0,2) != "=:") // second non whitespace string must be "=:"
                        continue;
                    // s = s.Substring(2).TrimStart(); // would mean that
                    // substitution string cannot start with whitespace
                    // chars like ' '. So in version 1.0.2 replaced with;
                    // s = s.Substring(2);
                    // and in version 1.0.3, to allow trailing whitespaces, with:
                    s = s.Substring(2,s.Length-3); // i. e. last character is ignored
                    // unfortunately this means, that *ini-file format has changed again
                    mdl.ConvertColl.Add(new Converter { chr=c, subst=s });
                }
            }

            // Set (initial) directory for files to process:
            string useDir = IniFileAccess.ReadIniValue("Pathes",
                "useDirectory",iniFile);
            if (useDir != null && !File.Exists(useDir) && Directory.Exists(useDir)) {
                useDir = useDir[useDir.Length-1] == '\\' ?
                    useDir.Substring(0,useDir.Length-1) : useDir;
                mdl.StartDirectory = useDir;
            }
            else
                mdl.StartDirectory = Environment.GetFolderPath(
                    Environment.SpecialFolder.MyDocuments);

            string htmMode = IniFileAccess.ReadIniValue("Modes",
                "htmlMode",iniFile);
            int val;
            mdl.HtmlMode = true;
            if (int.TryParse(htmMode,out val))
                if (val == 0)
                    mdl.HtmlMode = false;

            // Set file types to process:
            if (mdl.FileTypes == null)
                mdl.FileTypes = new List<string>();
            mdl.FileTypes.Clear();
            //mdl.Description = "HTML Files";
            temp = IniFileAccess.ReadIniKeyValuePairs(
                "FileTypes",iniFile);
            mdl.Description = IniFileAccess.ReadIniValue("FileTypes","description",iniFile);
            if (temp != null) {
                foreach (string str in temp) {
                    // MessageBox.Show(temp);
                    str.Trim();
                    if (str.StartsWith("description")) {
                        int i = str.IndexOf('=')+1;
                        if (i != -1)
                            mdl.Description = str.Substring(i).TrimStart();
                        continue;
                    }
                    if (str.StartsWith("*."))
                        mdl.FileTypes.Add(str);
                }
            }
            if (mdl.FileTypes.Count() == 0)
                mdl.FileTypes = new List<string> { "*.htm","*.html","*.php" };
            return 0;
        }

        internal List<string> handleStartBtn(Action<string> btnContent,
            Action<string> lblContent) {
            List<string> errList;
            if (mdl.SelectedFiles == null || mdl.SelectedFiles.Count == 0) {
                lblContent(Resources.lblProcessFilesNoFilesS);
                //return 0;
                return null;
            }
            //if (newLineConversion == null)
            //    newLineConversion = new NewLineConvert();
            switch (mdl.startBtn) {
            case Model.StartBtnState.Start:
                int filesProcessed = 0;
                int rslt = 0;
                // List<string> errList = new List<string>();
                errList = new List<string>();
                mdl.startBtn = Model.StartBtnState.Cancel;
                btnContent(Resources.btnCancelProcessingS);
                Dictionary<string,string> convertDic =
                    new Dictionary<string,string>();
                foreach (var convert in mdl.ConvertColl)
                    convertDic.Add(convert.chr,convert.subst);
                Model mdlcpy = new Model(mdl);
                CharSubstitute csubst = new CharSubstitute();
                foreach (var file in mdlcpy.SelectedFiles) {
                    lblContent(file);
                    rslt = csubst.processFile(file,mdlcpy.HtmlMode,convertDic,
                            errList,mdl.NewLineConversion,ref mdl.startBtn);
                    if (rslt < 0)
                        continue;
                    filesProcessed++;
                }
                object lck = new object(); // needed because lock(this) is dangerous
                lock(lck) {
                    if (mdl.startBtn == Model.StartBtnState.Start) { // if aborted
                        lblContent(string.Format(
                            Resources.lblProcessFilesAbortedS,filesProcessed,
                                -rslt-1));
                    }
                    else {
                        lblContent(string.Format(
                            Resources.lblProcessFilesCompletedS,filesProcessed));
                        mdl.startBtn = Model.StartBtnState.Start;
                    }
                    btnContent(Resources.btnStartProcessingS);
                }
                // break;
                if (errList.Count != 0)
                    return errList;
                else {
                    errList = null;
                    return null;
                }
            case Model.StartBtnState.Cancel:
                // Set signal, that processing shall be aborted:
                mdl.startBtn = Model.StartBtnState.Start;
                break;
            default:
                throw new Exception(
                    "Program error in ViewModel.handleStartBtn: default reached");
            }
            //return 0;
            return null;
        }
        internal void handleCancelBtn() {
            mdl.startBtn = Model.StartBtnState.Start;
        }

        internal bool isProcessing() {
            if (mdl.startBtn == Model.StartBtnState.Cancel)
                return true;
            return false;
        }

    } // class ViewModel

} // namespace charConvert
