err.bo  equ     -5
err.no  equ     -6
err.bp  equ     -15

bv_chbas equ    $30
bv_chp  equ     $34
bv_rip  equ     $58

ch.id   equ     $00
ch.lench equ    $28

io.edlin equ    $04
io.sbyte equ    $05
io.sstrg equ    $07
sd.chenq equ    $0B
sd.curs equ     $0F
sd.pos  equ     $10
sd.pcol equ     $13

bp.init equ     $110
ca.gtint equ    $112
ca.gtstr equ    $116
bv.chrix equ    $11A

* QL WORLD DIY TOOLKIT - EDLINE$ function, by Simon N Goodwin
* rewritten by Laurence W Reeves.
*
* Extended by (Hans-)Peter Sulzer (hps):
* Optional 4th parameter terminate% allowed, only first 3 bits used, i.e.
* allowed range for terminate% = 0 ... 7
* bit  terminating key allowed (except for ENTER, which is always allowed):
* 0    ENTER (10)
* 1    ESC (27)
* 2    Cursor up (Arrow up) (208)
* 3    Cursor down (Arrow down) (216)
* If one of these bits is set, the terminating char is the last char of the
* returned string (and should normally be stripped, before using the string)

        SECTION CODE

start
        lea     define,a1
        move.w  bp.init,a2
        jmp     (a2)

define
        dc.w    0,0             No procedures
        dc.w    1               One function
        dc.w    edline-*
        dc.b    7,'EDLINE$'
        dc.w    edlinel-*
        dc.b    7,'EDLINEL'     Get last character code of a string
        dc.w    edlin-*
        dc.b    6,'EDLIN$'      return string$(1 to len(string$)-1)
        dc.w    0               End of functions

* hps added the following code for getting the 4th parameter up to
* new label "paras3":
edline
        moveq   #err.bp,d0      BAD PARAMETER error
        moveq   #0,d7           Default: 4th para 0 (only ENTER allowed)
        move.l  a3,d4
        add.l   #4*8,d4
        cmpa.l  d4,a5
        bne.s   paras3          not 4 parameters, then test if 3
        adda.l  #3*8,a3         retrieve just the 4th parameter
        move.w  ca.gtint,a2     get an int
        jsr     (a2)
        bne     rts0
        suba.l  #3*8,a3         restore parameter pointer
        suba.l  #8,a5           3rd parameter is now last parameter
        moveq   #err.bp,d0      Bad parameter error
        move.w  0(a6,a1.l),d7   get 4th parameter
        cmpi.w  #1,d7           
        bcs     rts0            4th parameter must not be less than 1
        cmpi.w  #15,d7          and
        bhi     rts0            must not be greater than 15
* OLD:
*        tst.w   d7
*        bmi     rts0            negative values not allowed
*        cmpi.w  #7,d7
*        bhi     rts0            maximum allowed value 7 (all 3 bits set)

* now continue with old code from Lawrence and Simon:

paras3
        moveq   #err.bp,d0      BAD PARAMETER error
* hps commented next (IMHO wrong) line:
*        add.w   #3*8,a3
* hps instead changed commented line to:
        add.l   #3*8,a3
        cmp.l   a3,a5

        bne.s   rts0            Ensure exactly three parameters

* Get the default string

        subq.l  #8,a3           Retrieve just the last parameter
        move.w  ca.gtstr,a2     get a string
        jsr     (a2)
        bne.s   rts0

* Read the first two parameters: channel number and buffer size

        move.l  a3,a5
        sub.w   #2*8,a3         get the other two parameters
        move.w  ca.gtint,a2     get two ints
        jsr     (a2)
        bne.s   rts0
* hps added following line:
        move.w  d7,d4           save value of 4th parameter
        movem.w 0(a1,a6.l),d5-d7 Get channel number, buffer and string lengths

* Convert channel number to channel ID

        moveq   #err.no,d0      CHANNEL NOT OPEN error
        mulu    #ch.lench,d5    Find offset in table
        add.l   bv_chbas(a6),d5 Add base offset
        cmp.l   bv_chp(a6),d5   Check not beyond end
        bge.s   rts0
        move.l  ch.id(a6,d5.l),d5 Get channel ID
        bmi.s   rts0            Channel must be open

* Validate initial string length

        moveq   #err.bo,d0      BUFFER FULL error
        move.l  d6,d1
        sub.w   d7,d1           is the string already too big for the buffer?
        blt.s   rts0            if so (or buffer length is negative), get out
        addq.l  #2,d1           allow extra for coordinates if string is null
        move.w  bv.chrix,a2
        jsr     (a2)            ensure enough space for longest text

        move.l  bv_rip(a6),a2
        addq.l  #6,a2           position to start of default string

* Find out where we are on the screen

        move.l  d5,a0           Channel ID
        moveq   #-1,d3          Timeout

        lea     -8(a2),a1       place to read initial coords to
        moveq   #sd.chenq,d0
        bsr.s   rel_QDOS
        move.l  -4(a6,a2.l),d5  pick up coords and save them

* Put the string in the buffer

        addq.l  #1,d6           add one to buffer length for terminator
        lea     0(a2,d7.l),a3
        sub.l   d6,a3           good enough for buffer location
        move.l  a3,a1
        move.w  d7,d1
        bra.s   buff_ent

rel_QDOS
        trap    #4
call_QDOS
        trap    #3              General-purpose ROM caller
        tst.l   d0
        beq.s   rts0
        addq.l  #4,a7           Return to previous caller
rts0
        rts

buff_lp
        move.b  0(a6,a2.l),0(a6,a1.l)
        addq.l  #1,a2
        addq.l  #1,a1
buff_ent
        dbra    d1,buff_lp
        moveq   #1,d1
        and.w   d7,d1
        add.w   d1,a2           set top of stack

* Go to the initial cursor position and print the text

go_there
        move.l  d5,d1
        swap    d1              Extract cursor X
        move.w  d5,d2           Extract cursor Y
        moveq   #sd.pos,d0
        bsr.s   call_QDOS
        move.l  a3,a1
        move.w  d7,d2
        moveq   #io.sstrg,d0
        bsr.s   rel_QDOS
        moveq   #' ',d1
        moveq   #io.sbyte,d0    blank end of line
        bsr.s   call_QDOS
        moveq   #sd.pcol,d0     move cursor to blank
        bsr.s   call_QDOS

* Call up the editor

        move.w  d7,d1           Put cursor at end of text
        swap    d1
        move.w  d7,d1           Indicate length of text
        lea     0(a3,d1.w),a1   Point to last character
        move.w  d6,d2           Maximum length
        moveq   #io.edlin,d0
        trap    #4
        trap    #3
        subq.w  #1,d1           Don't count last character
        move.w  d1,d7           Slide up to the end-stop
        move.l  d0,d2           Save and test the error code
        beq.s   edited          No error: check terminator
        moveq   #sd.curs,d0     for AH & JM ROMs & err.bo
        bsr.s   call_QDOS       which leave the cursor on
        move.l  d2,d0           restore the error code
        addq.l  #-err.bo,d2     Was it buffer overflow?
        beq.s   go_there        Yes, so try again
        rts                     Give up if anything else!

edited
* Peter Sulzer added the following 4 lines in case 4th Parameter (d4)
* was 0, i.e. only ENTER as terminating character allowed:
        tst.w   d4
        bne.s   termchar         d4 <> 0, i.e. not just ENTER allowed
        cmpi.b  #10,-1(a6,a1.l)  terminating character was ENTER?
        bne.s   go_there         No so restart editing

org_code
* Original code from Simon and Lawrence if only ENTER is allowed an
* terminating char at the end of the string is stripped:
        sub.b   #10,-1(a6,a1.l) (tidy to make pad byte come out zero)
        bne.s   go_there        Restart unless last character was ENTER
        btst    d0,d1           see if string is an odd length
        beq.s   fin_ent         no padding byte
fin_loop
        move.b  -1(a6,a1.l),-1(a6,a2.l)
        subq.l  #1,a2
fin_ent
        subq.l  #1,a1
        dbra    d7,fin_loop
        move.l  a2,a1
        subq.l  #2,a1           Make room to stack length 
        move.l  a1,bv_rip(a6)   Reset maths stack pointer
        move.w  d1,0(a6,a1.l)   set string length
        moveq   #1,d4           Return a string
        rts

* END Original code from Simon and Lawrence if only ENTER is allowed


* Peter Sulzer added the following code when 4th parameter was <> 0
* and terminating character must be returned:

termchar
        cmpi.b  #15,d4           all terminating characters allowed?
        beq.s   restlen         yes
        move.b  -1(a6,a1.l),d3  get terminating character (d3 not used above)
        cmpi.b  #10,d3          test for ENTER
* OLD:
*        beq.s   restlen         ENTER is always allowed
* NEW:
        bne.s   escape          if not ENTER test for ESC
        move.b  #27,-1(a6,a1.l) set to another value than ENTER for original code
        btst    #0,d4           ENTER allowed?
        beq.s   org_code        no
        move.b  #10,-1(a6,a1.l) restore terminating character (the linefeed)  
        bra.s   restlen
escape
        cmpi.b  #27,d3          test for ESC
        bne.s   cursup          if not ESC test for cursor up
        btst    #1,d4           ESC allowed?
        beq.s   org_code        no
        bra.s   restlen
cursup
        cmpi.b  #208,d3         test for cursor up
        bne.s   cursdown        if not cursor up test for cursor down
        btst    #2,d4           cursor up allowed?
        beq.s   org_code        no
        bra.s   restlen
cursdown
        btst    #3,d4           cursor down allowed?
        beq.s   org_code        no
restlen
        addq.w  #1,d1           restore string length to d1
finLoop
        move.b  -1(a6,a1.l),-1(a6,a2.l)
        subq.l  #1,a2
finEnt
        subq.l  #1,a1
        dbra    d7,finLoop
        move.l  a2,a1
        subq.l  #2,a1           Make room to stack length 
        move.l  a1,bv_rip(a6)   Reset maths stack pointer
        move.w  d1,0(a6,a1.l)   set string length
        moveq   #1,d4           Return a string
        rts



edlinel
*     Get last character of a string
        move.w  ca.gtstr,a2
        jsr     (a2)
        subq.w  #1,d3           just one argument?
        bne.s   err_bp
* We must not reserve space on the maths stack, as ca.gtstr has already
* reserved a minimum of 2 bytes (string length of empty string)
        move.w  #-1,d5          default return is -1 (no last char)
        clr.l   d4              IMPORTANT: High word must be clear!
        move.w  0(a6,a1.l),d4   get string length
        beq.s   setRslt         0-length string, so return default
        adda.l  d4,a1           add string length
        addq.l  #1,a1           now (a6,a1.l) points to last char of string
        clr.w   d5
        move.b  0(a6,a1.l),d5   get code of last char
        btst    #0,d4           if stringlength is odd
        bne.s   setRslt         a1 points to result on math stack
        subq.l  #1,a1           but if even we must subtract 1

setRslt
        move.w  d5,0(a6,a1.l)   store return value on math stack
        move.l  a1,bv_rip(a6)   set qdos pointer to math stack
        moveq   #3,d4           we return an integer
        moveq   #0,d0           no error
        rts

err_bp
        moveq   #err.bp,d0
        rts


edlin
* strip last char of a string (for empty string, an empty string is returned)
        move.w  ca.gtstr,a2
        jsr     (a2)
        subq.w  #1,d3           just one argument?
        bne.s   err_bp
* We must not reserve space on the maths stack, as ca.gtstr has already
* reserved space for the string (our string is of lower length)
        clr.l   d4              IMPORTANT: High word must be clear!
        move.w  0(a6,a1.l),d4   get string length
        beq.s   edlinrts        string length 0 is trivial
        cmpi.w  #1,d4
        bne.s   testodd         string length 1
*                               needs special treatment:
        addq.l  #2,a1           adjust math stack
        move.w  #0,0(a6,a1.l)   set string length to 0
        bra.s   edlinrts
testodd
        btst    #0,d4           
        bne.s   odd_len         handle odd string length

* even string length is trivial: 
        subq.w  #1,0(a6,a1.l)   we must just subtract 1 from length word
        bra.s   edlinrts

odd_len
        adda.l  d4,a1           add length (a1 points to char before last char)
        move.l  a1,a4
        move.w  d4,d5           setup the
        subq.w  #2,d5           loop counter
cpystr
        move.b  0(a6,a1.l),1(a6,a4.l) copy the characters (we must copy up
*                                     2 bytes, as result string is even!
        subq.l  #1,a4
        subq.l  #1,a1
        dbra    d5,cpystr
        subq.w  #1,d4           string length is now one less
        move.w  d4,0(a6,a1.l)   store string length of returned string
edlinrts
        move.l  a1,bv_rip(a6)   set qdos pointer to math stack
        moveq   #1,d4           we return a string
        moveq   #0,d0           no error
        rts


        end
