100 REMark Unit Test Program for PSU_FPARSE%(float,stringExpression$)
110 REMark Copyright (c) 2025, Peter Sulzer Frth (Fuerth), all rights reserved
120 REMark This test requires the VALID function from knoware.no for test_para FNs.
130 :
140 CLEAR
150 FLOAT_LOW$='-1.6158502672999e616':FLOAT_LOW=FLOAT_LOW$
180 ok=0:ffalse=1:rfalse=2:restfalse=3:noErrRF=4:noErrR=5:errLeak=6:tests=0:passed=0:failed=0:skipped=0:outfile$='':DEF_FLT=1.234567
190 DIM fail$(6,32):fail$(0)='passed':fail$(1)='false float value':fail$(2)='false result':fail$(3)='false rest of string'
200 fail$(4)='No error and float changed':fail$(5)='No error for bad float string'
210 fail$(6)='Memory leak!'
220 c%=1:IF c%>3:INPUT'Enter output filename:',outfile$
260 IF c%>3:IF FOP_OVER(outfile$):PRINT#0,'Cannot open'!outfile$:GO TO 32750:END IF
280 :
300 rslt=test01():tests=tests+1:PRINT#c%,test$!fail$(rslt)
310 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
320 :
330 rslt=test02():tests=tests+1:PRINT#c%,test$!fail$(rslt)
340 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
350 :
360 rslt=test03():tests=tests+1:PRINT#c%,test$!fail$(rslt)
370 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
380 :
390 rslt=test04():tests=tests+1:PRINT#c%,test$!fail$(rslt)
400 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
410 :
420 rslt=test05():tests=tests+1:PRINT#c%,test$!fail$(rslt)
430 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
440 :
450 rslt=test_float('-4'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
460 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
470 rslt=test_float(' -1.6158499999999e616'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
480 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
490 rslt=test_float('+6abc'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
500 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
510 rslt=test_float('  .34xyz'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
520 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
890 :
900 rslt=test_leak:tests=tests+1:PRINT#c%,test$!fail$(rslt)
910 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
1800 :
1840 PRINT#c%,'Run'!tests!'tests,'!passed!'passed,'!failed!'failed,'!skipped!'skipped'
1880 IF c%>3:PRINT#0,'Run'!tests!'tests,'!passed!'passed,'!failed!'failed,'!skipped!'skipped':CLOSE#c%:END IF
1960 :
1980 :
2000 REMark Unit Tests
2040 :
2080 DEFine FuNction test01
2120   LOCal res,flt
2160   test$='test01'
2200   flt=99:res=PSU_FPARSE%(flt,'12.34e3')
2240   IF res=LEN('12.34e3')
2280     IF flt=12340:RETurn ok:ELSE RETurn ffalse:END IF
2320   ELSE
2360     RETurn rfalse
2400   END IF
2440 END DEFine
2480 :
2490 DEFine FuNction test02
2500   LOCal res,flt,t$
2510   flt=0:test$='test02':t$='  9.87e3nine thousand and eight hundretseventy'
2520   res=PSU_FPARSE%(flt,t$)
2530   IF res=8
2540     IF flt=9870
2550       IF t$(res+1TO 12)='nine':RETurn ok:ELSE RETurn restfalse:END IF
2560     ELSE
2570       RETurn ffalse
2580     END IF
2590   ELSE
2600     RETurn rfalse
2610   END IF
2620 END DEFine
2630 :
2640 DEFine FuNction test03
2650   LOCal res,flt
2660   test$='test03'
2670   flt=99:res=PSU_FPARSE%(flt,'12.34eThis string cannot be converted')
2680   IF res<0 AND flt=99:RETurn ok:END IF
2690   REMark IF res>=0
2700   IF res>=0:IF flt<>99:RETurn noErrRF:ELSE RETurn noErrR:END IF :END IF
2710 END DEFine
2720 :
2730 DEFine FuNction test04
2740   LOCal res,flt(2),t$
2750   test$='test04'
2760   t$='  15 16 17'
2770   flt(0)=97:flt(1)=98:flt(2)=99
2780   res=PSU_FPARSE%(flt(0),t$)
2790   IF res<>4:RETurn rfalse:END IF
2800   IF flt(0)<>15:RETurn ffalse:END IF
2810   res=res+PSU_FPARSE%(flt(1),t$(res+1 TO))
2820   IF res<>7:RETurn rfalse:END IF
2830   IF flt(1)<>16:RETurn ffalse:END IF
2840   res=res+PSU_FPARSE%(flt(2),t$(res+1 TO))
2850   IF res<>LEN(t$):RETurn rfalse:END IF
2860   IF flt(2)<>17:RETurn ffalse:END IF
2870   RETurn ok
2880 END DEFine
2890 :
2900 DEFine FuNction test05
2910   LOCal res,flt,t$
2920   test$='test05':t$='12.This will evaluate 12. from string (3 chars)'
2930   flt=99:res=PSU_FPARSE%(flt,t$)
2940   IF res=3
2950     IF flt=12
2960       IF t$(res+1TO 7)='This':RETurn ok:ELSE RETurn restfalse:END IF
2970     ELSE
2980       RETurn ffalse
2990     END IF
3000   ELSE
3010     RETurn rfalse
3020   END IF
3030 END DEFine
3990 :
4000 DEFine FuNction test_float(t_$)
4010   LOCal res
4020   test$='test_float'&': '&t_$
4030   flt=FLOAT_LOW:res=PSU_FPARSE%(flt,t_$)
4035   RETurn 0
4040   IF res<0:RETurn rfalse:END IF
4050   IF flt<>t_$(1TO res):RETurn ffalse:END IF
4060   RETurn ok
4070 END DEFine
4990 :
5000 DEFine FuNction test_leak
5010   LOCal flt,res,mem_start,mem_end,ii,long$,t$
5020   test$='test_leak':long$=FILL$('aB',2048)
5030   t$='1'&long$
5035   mem_start=FREE_MEM
5040   flt=0:res=PSU_FPARSE%(flt,t$):IF res<>1:RETurn rfalse:END IF
5050   IF flt<>1:RETurn ffalse
5070   FOR ii=0TO 999
5080     res=PSU_FPARSE%(flt,'1.234e3'):IF res<0:RETurn rfalse:END IF
5090     res=PSU_FPARSE%(flt,'   9.876'&long$):IF res<0:RETurn rfalse:END IF
5100     res=PSU_FPARSE%(flt,'   -.34e2'):IF res<0:RETurn rfalse:END IF
5110   END FOR ii
5120   mem_end=FREE_MEM
5130   IF mem_start<>mem_end:RETurn errLeak:END IF
5140   RETurn ok
5150 END DEFine
30000 :
30010 :
30020 :
30030 :
30040 :
30050 :
30060 :
30070 :
30080 :
30090 :
30100 :
30110 :
30120 :
30130 :
30140 :
30150 :
30160 :
