100 REMark Unit Test Program for PSU_FPARSE%(float,stringExpression$)
110 REMark Copyright (c) 2025, Peter Sulzer Frth (Fuerth), all rights reserved
120 REMark This test requires the VALID function from knoware.no for test_para FNs.
130 :
140 CLEAR
150 FLOAT_LOW$='-1.6158502672999e616':FLOAT_LOW=FLOAT_LOW$
180 ok=0:ffalse=1:rfalse=2:restfalse=3:noErrRF=4:noErrR=5:errLeak=6:tests=0:passed=0:failed=0:skipped=0:outfile$='':DEF_FLT=1.234567
190 DIM fail$(6,32):fail$(0)='passed':fail$(1)='false float value':fail$(2)='false result':fail$(3)='false rest of string'
200 fail$(4)='No error and float changed':fail$(5)='No error for bad float string'
210 fail$(6)='Memory leak!'
220 c%=1:IF c%>3:INPUT'Enter output filename:',outfile$
260 IF c%>3:IF FOP_OVER(outfile$):PRINT#0,'Cannot open'!outfile$:GO TO 32750:END IF
280 :
300 rslt=test01():tests=tests+1:PRINT#c%,test$!fail$(rslt)
310 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
320 :
330 rslt=test02():tests=tests+1:PRINT#c%,test$!fail$(rslt)
340 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
350 :
360 rslt=test03():tests=tests+1:PRINT#c%,test$!fail$(rslt)
370 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
380 :
390 rslt=test04():tests=tests+1:PRINT#c%,test$!fail$(rslt)
400 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
410 :
420 rslt=test05():tests=tests+1:PRINT#c%,test$!fail$(rslt)
430 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
440 :
450 rslt=test_float('-4'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
460 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
470 rslt=test_float(' -1.6158499999999e616'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
480 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
490 rslt=test_float('+6abc'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
500 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
510 rslt=test_float('  .34xyz'):tests=tests+1:PRINT#c%,test$!fail$(rslt)
520 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
890 :
900 rslt=test_leak:tests=tests+1:PRINT#c%,test$!fail$(rslt)
910 IF rslt:failed=failed+1:ELSE passed=passed+1:END IF
990 :
1040 rslt=test_paraf(,1):tests=tests+1:PRINT test$
1050 REMark IF rslt=0:passed=passed+1:PRINT#c%,'passed':ELSE failed=failed+1:PRINT#c%,'failed':END IF
1052 PRINT tests,passed,failed,skipped
1053 tests=tests+1
1055 IF VER$='HBA'
1060   rslt=test_paraf():test$='test_paraf both paras implicitly passed '
1070   IF rslt=0:passed=passed+1:PRINT test$;'passed':ELSE failed=failed+1:PRINT test$;'failed':END IF
1080 ELSE
1090   PRINT'Minerva aborts with "bad parameter" if first para implicitly omitted, skipped':skipped=skipped+1
1110 END IF
1115 PRINT tests,passed,failed,skipped
1120 fltxyz=99:rslt=test_paraf(fltxyz,9):tests=tests+1
1130 REMark FOLLOWING TEST MAY BEHAVE DIFFERENTLY ON MINERVA(!):
1140 test$='test_paraf: para 1 uninitialised '
1160 IF rslt=1 AND fltxyz=9
1180   passed=passed+1:PRINT#c%,test$;'(fltxyz=';fltxyz;') passed'
1200 ELSE
1220   failed=failed+1:PRINT#c%,test$;'(result<>1) failed'
1240 END IF
1260 flt=99:rslt=test_paraf(flt,,):tests=tests+1
1280 IF rslt=0
1300   IF flt<>99:failed=failed+1:PRINT#c%,test$;'(flt<>99) failed':ELSE passed=passed+1:PRINT#c%,test$;'passed':END IF
1320 ELSE
1340   failed=failed+1:PRINT#c%,test$!'(rslt=1) ';
1360   IF flt=99:PRINT#c%,'failed':ELSE PRINT#c%,' (flt<>99) failed':END IF
1380 END IF
1400 flt=99:rslt=test_paraf(flt,'9'):tests=tests+1
1420 IF flt=9AND rslt=1
1440   passed=passed+1:PRINT#c%,test$;'passed'
1460 ELSE
1480   failed=failed+1:PRINT#c%,test$;failed
1500 END IF
1520 flt=99:rslt=test_paraf(flt,9.1):tests=tests+1:PRINT#c%,test$;
1540 IF flt=9.1AND rslt=1:passed=passed+1:PRINT#c%,'passed':ELSE PRINT#c%,'failed':END IF
1560 flt=99:num%='9':rslt=test_paraf(flt,num%):tests=tests+1:PRINT test$;
1580 IF flt=9AND rslt=1:passed=passed+1:PRINT c%,'passed':ELSE PRINT c%,'failed':END IF
1800 :
1840 PRINT#c%,'Run'!tests!'tests,'!passed!'passed,'!failed!'failed,'!skipped!'skipped'
1880 IF c%>3:PRINT#0,'Run'!tests!'tests,'!passed!'passed,'!failed!'failed,'!skipped!'skipped':CLOSE#c%:END IF
1960 :
1980 :
2000 REMark Unit Tests
2040 :
2080 DEFine FuNction test01
2120   LOCal res,flt
2160   test$='test01'
2200   flt=99:res=PSU_FPARSE%(flt,'12.34e3')
2240   IF res=LEN('12.34e3')
2280     IF flt=12340:RETurn ok:ELSE RETurn ffalse:END IF
2320   ELSE
2360     RETurn rfalse
2400   END IF
2440 END DEFine
2480 :
2490 DEFine FuNction test02
2500   LOCal res,flt,t$
2510   flt=0:test$='test02':t$='  9.87e3nine thousand and eight hundretseventy'
2520   res=PSU_FPARSE%(flt,t$)
2530   IF res=8
2540     IF flt=9870
2550       IF t$(res+1TO 12)='nine':RETurn ok:ELSE RETurn restfalse:END IF
2560     ELSE
2570       RETurn ffalse
2580     END IF
2590   ELSE
2600     RETurn rfalse
2610   END IF
2620 END DEFine
2630 :
2640 DEFine FuNction test03
2650   LOCal res,flt
2660   test$='test03'
2670   flt=99:res=PSU_FPARSE%(flt,'12.34eThis string cannot be converted')
2680   IF res<0 AND flt=99:RETurn ok:END IF
2690   REMark IF res>=0
2700   IF res>=0:IF flt<>99:RETurn noErrRF:ELSE RETurn noErrR:END IF :END IF
2710 END DEFine
2720 :
2730 DEFine FuNction test04
2740   LOCal res,flt(2),t$
2750   test$='test04'
2760   t$='  15 16 17'
2770   flt(0)=97:flt(1)=98:flt(2)=99
2780   res=PSU_FPARSE%(flt(0),t$)
2790   IF res<>4:RETurn rfalse:END IF
2800   IF flt(0)<>15:RETurn ffalse:END IF
2810   res=res+PSU_FPARSE%(flt(1),t$(res+1 TO))
2820   IF res<>7:RETurn rfalse:END IF
2830   IF flt(1)<>16:RETurn ffalse:END IF
2840   res=res+PSU_FPARSE%(flt(2),t$(res+1 TO))
2850   IF res<>LEN(t$):RETurn rfalse:END IF
2860   IF flt(2)<>17:RETurn ffalse:END IF
2870   RETurn ok
2880 END DEFine
2890 :
2900 DEFine FuNction test05
2910   LOCal res,flt,t$
2920   test$='test05':t$='12.This will evaluate 12. from string (3 chars)'
2930   flt=99:res=PSU_FPARSE%(flt,t$)
2940   IF res=3
2950     IF flt=12
2960       IF t$(res+1TO 7)='This':RETurn ok:ELSE RETurn restfalse:END IF
2970     ELSE
2980       RETurn ffalse
2990     END IF
3000   ELSE
3010     RETurn rfalse
3020   END IF
3030 END DEFine
3990 :
4000 DEFine FuNction test_float(t_$)
4010   LOCal res
4020   test$='test_float'&': '&t_$
4030   flt=FLOAT_LOW:res=PSU_FPARSE%(flt,t_$)
4035   RETurn 0
4040   IF res<0:RETurn rfalse:END IF
4050   IF flt<>t_$(1TO res):RETurn ffalse:END IF
4060   RETurn ok
4070 END DEFine
4990 :
5000 DEFine FuNction test_leak
5010   LOCal flt,res,mem_start,mem_end,ii,long$,t$
5020   test$='test_leak':long$=FILL$('aB',2048)
5030   t$='1'&long$
5035   mem_start=FREE_MEM
5040   flt=0:res=PSU_FPARSE%(flt,t$):IF res<>1:RETurn rfalse:END IF
5050   IF flt<>1:RETurn ffalse
5070   FOR ii=0TO 999
5080     res=PSU_FPARSE%(flt,'1.234e3'):IF res<0:RETurn rfalse:END IF
5090     res=PSU_FPARSE%(flt,'   9.876'&long$):IF res<0:RETurn rfalse:END IF
5100     res=PSU_FPARSE%(flt,'   -.34e2'):IF res<0:RETurn rfalse:END IF
5110   END FOR ii
5120   mem_end=FREE_MEM
5130   IF mem_start<>mem_end:RETurn errLeak:END IF
5140   RETurn ok
5150 END DEFine
5490 :
5500 DEFine FuNction test_paraf(flt_,flt_$)
5540   REMark flt_$ should be omitted or passed as float, int or a string which can
5580   REMark be converted to a string. It assigns flt_$ to flt_ and returns 1
5620   REMark (success) if flt_$ is a float or can be converted to float. It does not
5660   REMark alter flt_ if flt_$ is an uninitialised variable or cannot be converted
5700   REMark to float and returns 0 (fail).
5740   LOCal flt,rslt,p1rslt
5780   test$='test_paraf ':IF VER$<>'HBA':flt=FLOAT_LOW:END IF
5820   REMark Test if actual parameter flt_$ passed is of type string:
5860   p1rslt=VALID%(-1,flt_):   REMark PRINT'p1rslt=';p1rslt
5865   IF p1rslt=0
5870     REMark Following would give invalid parameter: rslt=PSU_FPARSE%(flt_,flt_$)
5873     REMark If flt_ is implicitly omitted (), this works - STRANGE!
5880     test$=test$&'1st para explicitly omitted not possible, skipped':skipped=skipped+1:RETurn 0
5890   END IF
5900   rslt=VALID%(-1,flt_$):    REMark PRINT rslt
5940   SELect ON rslt
5980   =513
6020     REMark Do NOT run this test with uninitalised variable on none SMSQ/E
6030     :
6040     REMark When implicitly ommitted this works: p1rslt=PSU_FPARSE%(flt_,flt_$)
6050     :
6060     IF PSU_FPARSE%(flt,flt_$)<0
6100       test$=test$&"para can't be converted "
6140       RETurn 0
6180     ELSE
6220       REMark PRINT '"';flt;'"'
6260       flt_=flt:test$=test$&'string para converted ':RETurn 1
6300     END IF
6340   =0
6380     test$=test$&'explicitly omitted ':RETurn 0
6420   =514,515
6460     REMark Do NOT run this test with uninitalised variable on none SMSQ/E
6500     flt_=flt_$:test$=test$&'number assigned ':RETurn 1
6540   =1,2,3
6580     REMark Uninitialised variable passed, only detectable on SMSQ/E
6620     test$=test$&'uninitialised var. ':RETurn 0
6660   =REMAINDER
6700     test$=test$&'array or unknown '
6740     RETurn 0
6780   END SELect
6820   RETurn 1
6860 END DEFine
30000 :
30010 :
30020 :
30030 :
30040 :
30050 :
30060 :
30070 :
30080 :
30090 :
30100 :
30110 :
30120 :
30130 :
30140 :
30150 :
30160 :
