;fparse_asm - Parse String to Float for SuperBASIC and Return Chars Parsed
;Started: 2025-11-23 Sun, Last Update 2025-12-05 Fri
;Copyright (c) 2025, Peter Sulzer, Frth (Fuerth), all rights reserved
;Version 1.0.1

;Namespace: PSU_ (Peter Sulzer Utilities)

BP_INIT         equ     $110    ;Vector BP.INIT to define MC PROC/FNs
BP_LET          equ     $120    ;Vector BP.LET to return parameter value

BV_PFBAS        equ     $10     ;Start of program
BV_PFP          equ     $14     ;End of program
BV_RIP          equ     $58     ;RI stack "top"
BV_RIBAS        equ     $5c     ;RI stack base
BV_CHRIX        equ     $11a    ;Vector BV.CHRIX
BV_NBAS         equ     $18     ;BASIC Name Table
BV_NLBAS        equ     $20     ;BASIC Name List

CA_GTFP         equ     $114    ;Vector CA.GTFP to fetch floating point
CA_GTSTR        equ     $116    ;Vector CA.GTSTR to fetch string(s)

CN_DTOF         equ     $100    ;Vector CN.DTOF (convert string->float)

QSTR            equ     1       ;QDOS STRing
QFLT            equ     2       ;QDOS FLoaT
QINT            equ     3       ;QDOS INteger (WORD, i.e. short in C!)

ERR_OR          equ     -4      ;Error out of range
ERR_BP          equ     -15     ;Error bad parameter
ERR_OV          equ     -18     ;Error overflow


start
        lea     define,a1       ;Load Effective Adress of SB PROC/FNs
        move.w  BP_INIT,a2      ;We must call SB vector BP.INIT
        jmp     (a2)            ;DO IT!

define
        dc.w 0                  ;0 PROCedure(s)
        dc.w 0                  ;END of PROCedure definitions
        dc.w 2                  ;1 FuNc(s) (but names are long so 2)
        dc.w    psu_fparse-*    ;Floatingpoint PARSEing
        dc.b    11,'PSU_FPARSE%'
        dc.w 0                  ;END of FuNctions

 dc.b 68,'Copyright (c) 2025, Peter Sulzer Fuerth, all rights reserved. V1.0.1'
;         12345678901234567890123456789012345678901234567890123456789012345678
 dc.w 0

;  N O T   Y E T   T E S T E D  AFTER CHANGES 2025-11-28 Fri 01:56!

psu_fparse     ;Parse string to float
        move.l   a5,d5          ;Save address of last parameter
        suba.l   #16,a5         ;Subtract 2 name table entries (16 bytes)
        cmp.l    a5,a3          ;is equal with address of first para?
        bne      error_bp       ;No (2 parameters required)
        addq.l   #8,a5          ;Point after first parameter
        move.l   BV_RIP(a6),a1  ;Pointer to RI stack must be in a1
        ;MY_VERSION: move.l   a1,d6          ;save RI stack pointer at entry
        move.l   a1,d6          ;PERS_Version: Save "empty" RI stack pointer
        sub.l    BV_RIBAS(a6),d6 ;             Make it relative to BAS
        move.w   CA_GTFP,a0     ;Get...
        jsr      (a0)           ;...float
        bne      error_bp       ;Oops (no float as 1st parameter)
        move.l   d5,a5          ;Restore a5
        movea.l  a3,a4          ;Save pointer to first parameter
        addq.l   #8,a3          ;Make a3 pointer to last (2nd) parameter
        move.w   CA_GTSTR,a0    ;Get...
        jsr      (a0)           ;...string
        bne      error_bp       ;Oops (no string as 2nd parameter)
        ;MY_VERSION: move.l   a1,d4          ;Calculate bytes pushed...
        ;MY_VERSION: sub.l    d4,d6          ;...to RI stack

        move.l   a1,a0          ;Find text start
        adda.w   0(a1,a6.l),a0  ;Add length
        addq.l   #2,a0          ;Point to end
        move.l   a0,d7          ;D7 -> End+1
        lea.l    2(a1),a0       ;A0 -> Start
      ; ---- Extended version return no of chars converted: ----
        move.l   a0,d5          ;Save Start (updated by CN.DTOF)
      ; --- END Extended version return no of chars converted --
get_float
        move.l   a1,BV_RIP(a6)  ;Save current RI stack ptr in BV.RIP 
        moveq    #6,d1          ;Space for 1 float must be...
        move.w   BV_CHRIX,a2    ;...reserved on RI stack
        jsr      (a2)
        move.l   BV_RIP(a6),a1  ;Stack may have moved, restore it

        move.w   CN_DTOF,a2     ;Convert string->float with CN.DTOF
        jsr      (a2)
        move.l   d0,d4          ;save result (d4 was only needed to
                                ;calculate no. of bytes on stack)
        bne.s    ret_result     ;Oops string cannot be converted
      ; ---- Extended version return no of chars converted: ----
        sub.l     a0,d5         ;Calculate no of chars...
        neg.l     d5            ;...converted
      ; --- END Extended version return no of chars converted --
        ;addq.l   #6,d6          ;Add float (6 bytes) to bytes pushed to RI-stack
        movea.l  a4,a3          ;Restore a3 to point to first parameter

      ; ****************************************************************
      ; VERY IMPORTANT(!): For BP.LET also BV.RIP must point to top of
      ;                    RI stack. This is neither documented in
      ;                    Technical Guide nor QL Advanced User Guide
      ;                    but is documented in The Sinclair QDOS
      ;                    Companion from Andrew Pennell:
        move.l   a1,BV_RIP(a6)  ;Set BV.RIP to point to top of RI stack
      ; ****************************************************************

        move.w   BP_LET,a2      ;Set value of first parameter to value
        jsr      (a2)                                        ;on RI stack
        beq.s    ret_result     ;Parameter has been set successfully
        move.l   d0,d4          ;Error setting parameter, copy result

ret_result
        ;MY_VERSION: move.l   BV_RIP(a6),a1  ;Get RI stack pointer (smashed by BP_LET)
        ;MY_VERSION: adda.l   d6,a1          ;Let a1 point to RI stack as it was on
        ;MY_VERSION:                         ;entry of the call to psu_fparse.
        add.l    BV_RIBAS(a6),d6 ;PERS_VERSION: Restore old stack relationship
        move.l   d6,a1          ;A1 must of course also point to RI stack top
        subq.l   #2,a1          ;Add room for an int
        ;move.l   d6,BV_RIP(a6)  ;PERS_VERSION: Tidy stack - We must now use:
        move.l   a1,BV_RIP(a6)  ;Let BV_RIP point to RI stack top
      ; ---- Extended version return no of chars converted: ----
        ;move.w   d4,0(a6,a1.l)  ;Put result (function result) on RI stack
      ; --- END Extended version return no of chars converted --
        tst.l     d4            ;Did BP.LET return an error?
        bpl.s     bp_let_ok     ;No
        move.w    d4,0(a6,a1.l) ;Put error result (func. result) on RI stack
        bra.s     bp_let_err    ;Return with error result
bp_let_ok
        move.w    d5,0(a6,a1.l) ;Put index of 1st char not converted on RI stack
      ; - END Extended version return index of 1st char not converted --
bp_let_err
        moveq    #QINT,d4       ;Set return type (3 is integer)
        clr.l    d0             ;Set no error
all_done
        rts

error_bp
        moveq    #ERR_BP,d0
        rts
;END

