/*
 * Decompiled with CFR 0.152.
 */
package utils.casts;

import javax.validation.constraints.NotNull;

public class IntBox
implements Cloneable {
    public static final int MAX_INT_LEN = String.valueOf(Integer.MAX_VALUE).length();
    public static final int MIN_INT_LEN = String.valueOf(Integer.MIN_VALUE).length();
    public static final int MAX_INT_LASTDEC = Integer.parseInt(String.valueOf(Integer.MAX_VALUE).substring(1));
    public static final int MAX_INT_FIRSTDIGIT = Integer.parseInt(String.valueOf(Integer.MAX_VALUE).substring(0, 1));
    public static final int MIN_INT_LASTDEC = -Integer.parseInt(String.valueOf(Integer.MIN_VALUE).substring(2));
    public static final int MIN_INT_FIRSTDIGIT = Integer.parseInt(String.valueOf(Integer.MIN_VALUE).substring(1, 2));
    public static final int MAX_INT_FIRSTDEC = Integer.parseInt(String.valueOf(Integer.MAX_VALUE).substring(0, String.valueOf(Integer.MAX_VALUE).length() - 1));
    public static final int MAX_INT_LASTDIGIT = Integer.parseInt(String.valueOf(Integer.MAX_VALUE).substring(String.valueOf(Integer.MAX_VALUE).length() - 1));
    public static final int MIN_INT_FIRSTDEC = Integer.parseInt(String.valueOf(Integer.MIN_VALUE).substring(0, String.valueOf(Integer.MIN_VALUE).length() - 1));
    public static final int MIN_INT_LASTDIGIT = Integer.parseInt(String.valueOf(Integer.MIN_VALUE).substring(String.valueOf(Integer.MIN_VALUE).length() - 1));
    public static final int[][] DECVALS = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {0, 10, 20, 30, 40, 50, 60, 70, 80, 90}, {0, 100, 200, 300, 400, 500, 600, 700, 800, 900}, {0, 1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000}, {0, 10000, 20000, 30000, 40000, 50000, 60000, 70000, 80000, 90000}, {0, 100000, 200000, 300000, 400000, 500000, 600000, 700000, 800000, 900000}, {0, 1000000, 2000000, 3000000, 4000000, 5000000, 6000000, 7000000, 8000000, 9000000}, {0, 10000000, 20000000, 30000000, 40000000, 50000000, 60000000, 70000000, 80000000, 90000000}, {0, 100000000, 200000000, 300000000, 400000000, 500000000, 600000000, 700000000, 800000000, 900000000}, {0, 1000000000, 2000000000}};
    protected int _n;
    public static final String INT_OVERFLOW = "-2147483648 <= first argument <= 2147483647";
    public static final String UNINITALIZED_INTBOX = "Uninitialized IntBox (i. e. null) not allowed as parameter!";
    public static final String INVALID_ARGUMENT = "Argument must be an Integer in the range of: ";

    @NotNull
    public static IntBox makeIntBox() {
        return new IntBox();
    }

    @NotNull
    public static IntBox makeIntBox(int n) {
        return new IntBox(n);
    }

    @NotNull
    public static IntBox makeIntBox(long l, int defaultValue) {
        return new IntBox(l, defaultValue);
    }

    @NotNull
    public static IntBox makeIntBox(double d, int defaultValue) {
        return new IntBox(d, defaultValue);
    }

    @NotNull
    public static IntBox makeIntBox(String s, int defaultValue) {
        return new IntBox(s, defaultValue);
    }

    @NotNull
    public static IntBox makeIntBox(IntBox ib, int defaultValue) {
        return new IntBox(ib, defaultValue);
    }

    public IntBox() {
        this._n = 0;
    }

    protected IntBox(int n) {
        this._n = n;
    }

    protected IntBox(long l, int defaultValue) {
        this._n = l < Integer.MAX_VALUE && l > Integer.MIN_VALUE ? (int)l : defaultValue;
    }

    protected IntBox(double d, int defaultValue) {
        this._n = d < 2.147483647E9 && d > -2.147483648E9 ? (int)d : defaultValue;
    }

    protected IntBox(String s, int defaultValue) {
        if (!IntBox.tryParse(s, this)) {
            this._n = defaultValue;
        }
    }

    protected IntBox(IntBox ib, int defaultValue) {
        this._n = ib == null ? defaultValue : ib._n;
    }

    public int v() {
        return this._n;
    }

    public int get() {
        return this._n;
    }

    public int set(int n) {
        this._n = n;
        return this._n;
    }

    public int set(long l, int defaultValue) {
        this._n = l < Integer.MAX_VALUE && l > Integer.MIN_VALUE ? (int)l : defaultValue;
        return this._n;
    }

    public int set(double d, int defaultValue) {
        this._n = d < 2.147483647E9 && d > -2.147483648E9 ? (int)d : defaultValue;
        return this._n;
    }

    protected int set(IntBox ib) throws IllegalArgumentException {
        if (ib == null) {
            throw new IllegalArgumentException(UNINITALIZED_INTBOX);
        }
        this._n = ib._n;
        return this._n;
    }

    protected IntBox setIntBox(IntBox intBox, int defaultValue) {
        if (intBox == null) {
            return new IntBox(defaultValue);
        }
        return intBox;
    }

    public int set(String s, int defaultValue) {
        try {
            this._n = Integer.parseInt(s);
        }
        catch (Exception e) {
            this._n = defaultValue;
        }
        return this._n;
    }

    public static boolean tryParseWithTable(String s, IntBox intBox) {
        if (intBox == null) {
            return false;
        }
        s = s.trim();
        int len = s.length();
        boolean negative = false;
        int rslt = 0;
        char c = s.charAt(0);
        if (c == '-') {
            negative = true;
        }
        if (len > MAX_INT_LEN) {
            s = IntBox.ltrimZeroes(s);
            len = s.length();
        }
        if (!(len <= MAX_INT_LEN || negative && len <= MIN_INT_LEN)) {
            return false;
        }
        if (negative) {
            int minIntLen = MIN_INT_LEN - 2;
            int i = len - 1;
            int j = 0;
            while (i >= 1) {
                c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                int d = c - 48;
                if (j >= minIntLen) {
                    if (d > MIN_INT_FIRSTDIGIT) {
                        return false;
                    }
                    if (d == MIN_INT_FIRSTDIGIT && rslt < MIN_INT_LASTDEC) {
                        return false;
                    }
                }
                rslt -= DECVALS[j][d];
                --i;
                ++j;
            }
        } else {
            int maxIntLen = MAX_INT_LEN - 1;
            int i = len - 1;
            int j = 0;
            while (i >= 0) {
                c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                int d = c - 48;
                if (j >= maxIntLen) {
                    if (d > MAX_INT_FIRSTDIGIT) {
                        return false;
                    }
                    if (d == MAX_INT_FIRSTDIGIT && rslt > MAX_INT_LASTDEC) {
                        return false;
                    }
                }
                rslt += DECVALS[j][d];
                --i;
                ++j;
            }
        }
        intBox._n = rslt;
        return true;
    }

    public static String ltrimZeroes(String s) {
        if (s.charAt(0) == '-') {
            return IntBox.ltrimZeroesNegative(s);
        }
        return IntBox.ltrimZeroesPositive(s);
    }

    protected static String ltrimZeroesNegative(String s) {
        int i = 1;
        while (s.charAt(i) == '0') {
            ++i;
        }
        return "-" + s.substring(i);
    }

    protected static String ltrimZeroesPositive(String s) {
        int i = 0;
        while (s.charAt(i) == '0') {
            ++i;
        }
        return s.substring(i);
    }

    public static boolean tryParse(String s, IntBox intBox) {
        if (intBox == null) {
            return false;
        }
        s = s.trim();
        int len = s.length();
        int rslt = 0;
        int dfirst = 0;
        char c = s.charAt(0);
        if (c == '-') {
            if (len > MIN_INT_LEN) {
                s = IntBox.ltrimZeroesNegative(s);
                len = s.length();
            }
            if (len >= MIN_INT_LEN) {
                c = s.charAt(1);
                if (!Character.isDigit(c)) {
                    return false;
                }
                dfirst = c - 48;
                if (len > MIN_INT_LEN || dfirst > MIN_INT_FIRSTDIGIT) {
                    return false;
                }
            }
            int i = len - 1;
            int j = 1;
            while (i >= 2) {
                c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                rslt -= (c - 48) * j;
                --i;
                j *= 10;
            }
            if (len < MIN_INT_LEN) {
                c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                rslt -= (c - 48) * j;
            } else {
                if (dfirst >= MIN_INT_FIRSTDIGIT && rslt < MIN_INT_LASTDEC) {
                    return false;
                }
                rslt -= dfirst * j;
            }
        } else {
            if (len > MAX_INT_LEN) {
                s = IntBox.ltrimZeroesPositive(s);
                len = s.length();
            }
            if (len >= MAX_INT_LEN) {
                c = s.charAt(0);
                if (!Character.isDigit(c)) {
                    return false;
                }
                dfirst = c - 48;
                if (len > MAX_INT_LEN || dfirst > MAX_INT_FIRSTDIGIT) {
                    return false;
                }
            }
            int i = len - 1;
            int j = 1;
            while (i >= 1) {
                c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                rslt += (c - 48) * j;
                --i;
                j *= 10;
            }
            if (len < MAX_INT_LEN) {
                c = s.charAt(i);
                if (!Character.isDigit(c)) {
                    return false;
                }
                rslt += (c - 48) * j;
            } else {
                if (dfirst >= MAX_INT_FIRSTDIGIT && rslt > MAX_INT_LASTDEC) {
                    return false;
                }
                rslt += dfirst * j;
            }
        }
        intBox._n = rslt;
        return true;
    }

    public Object clone() {
        return new IntBox(this._n);
    }

    public String toString() {
        return Integer.toString(this._n);
    }
}

