/**
 * Created by hps on 05.08.2016.
 */

import utils.casts.IntBox;

public class IntBoxBench {
    private static final boolean DEBUG = false;
    public static int[] rpi, rtpe, rtpf, rtpb, rtpt, rtpfa, rtpba;
    public static final int R_ARR_SZ=20;
    public static final String[] ints = {
        "123", String.valueOf(Integer.MIN_VALUE), "1000", "-123", "123456789",
        "1000000", "-2000000", "1", "7", "42",
        "9847","-3245","3","77","8","-101","-2","9","0",String.valueOf(Integer.MAX_VALUE),"-1"
    };
    public static void main(String[] args) {
        // Benchmark without IntBox:
        final int LOOPS = 1000000;

        IntBoxBench ibb=new IntBoxBench();
        long swo0End, swoEnd, stpfEnd, stpbEnd, stpeEnd, stpwtEnd, stpfaEnd, stpbaEnd;
        
        if (DEBUG) {
            rpi=new int[R_ARR_SZ]; rtpe=new int[R_ARR_SZ];
            rtpf=new int[R_ARR_SZ]; rtpt=new int[R_ARR_SZ]; rtpfa=new int[R_ARR_SZ];
            rtpb=new int[R_ARR_SZ]; rtpba=new int[R_ARR_SZ];
        }

    for (int ii=0; ii < 5; ++ii) {

        // First Test is dummy (exactly the same as next, because
        // of JIT-compiler, which seems to compile after first
        // loop:
        long swo0Start = System.currentTimeMillis();
        for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
            int j, i;
            String s;
            for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
                i = Integer.parseInt(s);
                if (DEBUG) {
                    rpi[j] = i;
                }
            }
        }
        swo0End = System.currentTimeMillis();

        long swoStart = System.currentTimeMillis();
        for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
            int j, i;
            String s;
            for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
                i = Integer.parseInt(s);
                if (DEBUG) {
                    rpi[j] = i;
                }
            }
        }
        swoEnd = System.currentTimeMillis();

        long stpeStart = System.currentTimeMillis();
        //IntBox ibtpe = IntBox.makeIntBox();
        //for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
        //    int j, i;
        //    String s;
        //    for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
        //        IntBox.tryParseExcept(s, ibtpe);
        //        if (DEBUG) {
        //            rtpe[j] = ibtpe.v();
        //        }
        //    }
        //}
        stpeEnd = System.currentTimeMillis();

        long stpwtStart = System.currentTimeMillis();
        IntBox ibwt = IntBox.makeIntBox();
        for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
            int j, i;
            String s;
            for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
                IntBox.tryParseWithTable(s, ibwt);
                // i=ibwt.v();
                if (DEBUG) {
                    rtpt[j] = ibwt.v();
                }
            }
        }
        stpwtEnd = System.currentTimeMillis();

        // Dummy loop to fix wrong time because of JIT-compiler
        //long stpf0Start = System.currentTimeMillis();
        //IntBox ibtpf0 = IntBox.makeIntBox();
        //for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
        //    int j, i;
        //    String s;
        //    for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
        //        IntBox.tryParseForward(s, ibtpf0);
        //        if (DEBUG) {
        //            rtpf[j] = ibtpf0.v();
        //        }
        //    }
        //}
        stpfEnd = System.currentTimeMillis();

        long stpfStart = System.currentTimeMillis();
        //IntBox ibtpf = IntBox.makeIntBox();
        //for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
        //    int j, i;
        //    String s;
        //    for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
        //        IntBox.tryParseForward(s, ibtpf);
        //        if (DEBUG) {
        //            rtpf[j] = ibtpf.v();
        //        }
        //    }
        //}
        stpfEnd = System.currentTimeMillis();

        // Dummy loop to fix wrong time because of JIT-compiler
        long stpb0Start = System.currentTimeMillis();
        IntBox ibtpb = IntBox.makeIntBox();
        for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
            int j, i;
            String s;
            for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
                IntBox.tryParse(s, ibtpb);
                if (DEBUG) {
                    rtpb[j] = ibtpb.v();
                }
            }
        }
        stpbEnd = System.currentTimeMillis();

        long stpbStart = System.currentTimeMillis();
        IntBox ibtpb0 = IntBox.makeIntBox();
        for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
            int j, i;
            String s;
            for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
                IntBox.tryParse(s, ibtpb0);
                if (DEBUG) {
                    rtpb[j] = ibtpb0.v();
                }
            }
        }
        stpbEnd = System.currentTimeMillis();

        long stpfaStart = System.currentTimeMillis();
        //IntBox ibtpfa = IntBox.makeIntBox();
        //for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
        //    int j, i;
        //    String s;
        //    for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
        //        IntBox.tryParseForward(s, ibtpfa);
        //        i = ibtpfa.v();
        //        if (DEBUG) {
        //            rtpfa[j] = ibtpfa.v();
        //        }
        //    }
        //}
        stpfaEnd = System.currentTimeMillis();

        long stpbaStart = System.currentTimeMillis();
        IntBox ibtpba = IntBox.makeIntBox();
        for (int loop = 0; loop < LOOPS; loop++) { // run test 100 times
            int j, i;
            String s;
            for (j = 0, s = ints[j]; s != "-1"; s = ints[++j]) {
                IntBox.tryParse(s, ibtpba);
                i = ibtpba.v();
                if (DEBUG) {
                    rtpba[j] = ibtpba.v();
                }
            }
        }
        stpbaEnd = System.currentTimeMillis();



        if (DEBUG) {
            for (int i=0; i < R_ARR_SZ; i++) {
                System.out.printf("%d | %d | %d | %d | %d | %d%n",
                    rpi[i],rtpe[i],rtpt[i],rtpf[i],rtpb[i],rtpfa[i],rtpba[i]);
            }
        }
        System.out.printf("%nTimes in milli seconds:%n");
        System.out.printf("%d | %d | %d | %d | %d | %d | %d%n",swoEnd-swoStart,
                stpeEnd-stpeStart,stpwtEnd-stpwtStart,stpfEnd-stpfStart,
                stpbEnd-stpbStart,stpfaEnd-stpfaStart,stpbaEnd-stpbaStart);

    } // FixBenchLoopEnd

    } // main()
}
